import Foundation
import CoreBluetooth

class bleModel: NSObject, CBCentralManagerDelegate, CBPeripheralDelegate  {
    
    
    
    // Declare variables:
    let mArray = 6
    let nArray = 6
    static let nPixels = 36
    var pixelData = [UInt8](repeating: 0x00, count: nPixels)
    var bleData = [UInt8](repeating: 0x00, count: 14)
    var bluetoothOn = false
    var bleConnected = false
    var bleReadyToRead = false
    var cybleServiceUUID = CBUUID(string: "00000000-0000-0000-0000-000000000000")
    var cybleCharacteristicUUID = CBUUID(string: "00000000-0000-0000-0000-000000000000")
    private var centralManager : CBCentralManager!
    private var cybleDevice : CBPeripheral?
    private var cybleService : CBService!
    private var cybleCharacteristic : CBCharacteristic!
    
    
    
    // What to do when the central manager updates the state:
    func centralManagerDidUpdateState(_ central: CBCentralManager) {
        switch central.state {
            case .unknown:
                NotificationCenter.default.post(name: Notification.Name("updateBleStatus"), object: nil, userInfo: ["Status": "Status: Unknown!"])
            case .resetting:
                NotificationCenter.default.post(name: Notification.Name("updateBleStatus"), object: nil, userInfo: ["Status": "Status: Resetting ..."])
            case .unsupported:
                NotificationCenter.default.post(name: Notification.Name("updateBleStatus"), object: nil, userInfo: ["Status": "Status: Unsupported!"])
            case .unauthorized:
                NotificationCenter.default.post(name: Notification.Name("updateBleStatus"), object: nil, userInfo: ["Status": "Status: Unauthorized!"])
            case .poweredOff:
                NotificationCenter.default.post(name: Notification.Name("updateBleStatus"), object: nil, userInfo: ["Status": "Status: Powered off!"])
                centralManager?.stopScan()
                bluetoothOn = false
            case .poweredOn:
                NotificationCenter.default.post(name: Notification.Name("updateBleStatus"), object: nil, userInfo: ["Status": "Status: Powered on!"])
                bluetoothOn = true
        @unknown default:
            NotificationCenter.default.post(name: Notification.Name("updateBleStatus"), object: nil, userInfo: ["Status": "Status: Unknown!!"])
        }
    }
    
    
    
    // Update the UUID for the service and characteristic
    func updateUUID(serviceUUID: String, characteristicUUID: String){
        cybleServiceUUID = CBUUID(string: serviceUUID)
        cybleCharacteristicUUID = CBUUID(string: characteristicUUID)
    }
    
    
    
    // Update the data array that are being sent and received through bluetooth
    func updateData(index i: Int, value val: Float){
        bleData[i] = UInt8(val)
    }
    func togglePixel(index i: Int){
        if pixelData[i] == 0x00 {pixelData[i] = 0x01}
        else if pixelData[i] == 0x01 {pixelData[i] = 0x00}
        pixelToVector(m: mArray, n: nArray)
    }
    func pixelToVector(m: Int, n: Int){
        for i in 1..<bleData.count {
            bleData[i] = 0x00
        }
        for j in 0..<n {
            for i in 0..<m {
                if pixelData[j*n+i] == 0x01 {
                    bleData[i+1]=0x01
                    bleData[j+m+1]=0x01
                }
            }
        }
    }
    
    
    
    // ------------------------------------------------------------
    // Connect to the BLE device:
    // 1. Power on the bluetooth if it's off and start scanning for the device with the given service uuid:
    func connectToDevice() {
        // If the bluetooth is not on, then turn it on:
        if bluetoothOn == false {
            centralManager = CBCentralManager(delegate: self, queue: nil)
            Timer.scheduledTimer(timeInterval: 1, target: self, selector: #selector(self.startScan), userInfo: nil, repeats: false)
            NotificationCenter.default.post(name: Notification.Name("updateBleStatus"), object: nil, userInfo: ["Status": "Status: Bluetooth started!"])
        }
        else {
            startScan()
        }
    }
    @objc func startScan(){
        // If no device is connected then start scanning for the device:
        if bleConnected == false{
            centralManager.scanForPeripherals(withServices: [cybleServiceUUID], options: nil)
            NotificationCenter.default.post(name: Notification.Name("updateBleStatus"), object: nil, userInfo: ["Status": "Status: Scanning for the device ..."])
        }
    }
    // 2. When the device is found, try to establish a connection
    func centralManager(_ central: CBCentralManager, didDiscover peripheral: CBPeripheral, advertisementData: [String : Any], rssi RSSI: NSNumber) {
        if cybleDevice == nil {
            cybleDevice = peripheral
            centralManager.stopScan()
        }
        centralManager.connect(cybleDevice!, options: nil)
        NotificationCenter.default.post(name: Notification.Name("updateBleStatus"), object: nil, userInfo: ["Status": "Status: Connecting to the device ..."])
    }
    // 3. When the connection is established, search for the services
    func centralManager(_ central: CBCentralManager, didFailToConnect peripheral: CBPeripheral, error: Error?) {
        NotificationCenter.default.post(name: Notification.Name("updateBleStatus"), object: nil, userInfo: ["Status": "Status: Failed to connect!"])
    }
    func centralManager(_ central: CBCentralManager, didConnect peripheral: CBPeripheral) {
        NotificationCenter.default.post(name: Notification.Name("updateBleStatus"), object: nil, userInfo: ["Status": "Status: Connecting to the service ..."])
        cybleDevice!.delegate = self
        cybleDevice!.discoverServices(nil)
        bleConnected = true
    }
    // 4. When the service is found, search for the characteristics
    func peripheral(_ peripheral: CBPeripheral, didDiscoverServices error: Error?) {
        for service in peripheral.services! {
            if service.uuid == cybleServiceUUID {
                cybleService = service
            }
            NotificationCenter.default.post(name: Notification.Name("updateBleStatus"), object: nil, userInfo: ["Status": "Status: Connecting to the characteristic ..."])
            cybleDevice!.discoverCharacteristics(nil, for: cybleService)
        }
    }
    // 5. When the characteristic is found, assign it to cybleCharacteristic
    func peripheral(_ peripheral: CBPeripheral, didDiscoverCharacteristicsFor service: CBService, error: Error?) {
        for characteristic in service.characteristics! {
            if characteristic.uuid == cybleCharacteristicUUID {
                cybleCharacteristic = characteristic
            }
        }
        NotificationCenter.default.post(name: Notification.Name("updateBleStatus"), object: nil, userInfo: ["Status": "Status: Connected!"])
        bleReadyToRead = true
        writeData()
    }
    
    
    
    // ------------------------------------------------------------
    // Disconnect from the device:
    func disconnectDevice() {
        if bleConnected == true {
            centralManager.cancelPeripheralConnection(cybleDevice!)
            NotificationCenter.default.post(name: Notification.Name("updateBleStatus"), object: nil, userInfo: ["Status": "Status: Disconnecting ..."])
        }
    }
    // When the device is disconnected set cybleDevice to nil
    func centralManager(_ central: CBCentralManager, didDisconnectPeripheral peripheral: CBPeripheral, error: Error?) {
        if peripheral == cybleDevice {
            cybleDevice = nil
            NotificationCenter.default.post(name: Notification.Name("updateBleStatus"), object: nil, userInfo: ["Status": "Status: Disconnected!"])
            bleConnected = false
            bleReadyToRead = false
        }
    }
    
    
    
    // ------------------------------------------------------------
    // Send data to the device:
    var writeTimer : Timer?
    @objc func writeData() {
        if bleReadyToRead == true {
            let data = Data(bytes: &bleData, count: bleData.count)
            cybleDevice!.writeValue(data, for: cybleCharacteristic, type: CBCharacteristicWriteType.withResponse)
            bleReadyToRead = false
            NotificationCenter.default.post(name: Notification.Name("updateBleStatus"), object: nil, userInfo: ["Status": "Status: Sending data ..."])
            writeTimer = Timer.scheduledTimer(timeInterval: 1, target: self, selector: #selector(self.resendData), userInfo: nil, repeats: false)
        }
    }
    // Check if the data are sent:
    func peripheral(_ peripheral: CBPeripheral, didWriteValueFor characteristic: CBCharacteristic, error: Error?) {
        NotificationCenter.default.post(name: Notification.Name("updateBleStatus"), object: nil, userInfo: ["Status": "Status: Communication successful!"])
        writeTimer?.invalidate()
        writeTimer = nil
        bleReadyToRead = true
    }
    // If the data is not sent after 1s, disconnect, reconnect, and resnd the data after 1s:
    @objc func resendData(){
        disconnectDevice()
        bleConnected = false
        connectToDevice()
    }
    // ------------------------------------------------------------
}
